#' @title Creates a dataframe containing the holistic judgments
#'
#' @description Function to build the judgment matrix based on a vector of weights.
#'
#' @param x A vector of names (criteria or choices).
#' @param y A vector of weights on the Saaty scale, typically in [1, 9].
#'
#' @return Returns a square judgment matrix (n x n).
#'
#' @author Luciane Ferreira Alcoforado
#'
#' @examples
#' x <- c("c1", "c2", "c3", "c4")
#' y <- c(3, 9, 2, 8)
#' matrix_ahp(x, y)
#'
#' @export
matrix_ahp <- function(x, y) {
  
  # Validação básica
  if (length(x) != length(y)) {
    stop("The vectors 'x' and 'y' must have the same length.")
  }
  
  n <- length(x)
  m <- diag(n)
  colnames(m) <- x
  rownames(m) <- x
  
  for (i in 1:(n - 1)) {
    for (j in (i + 1):n) {
      # Lógica da escala de Saaty adaptada
      m[i, j] <- ifelse(y[i] < y[j], 1 / (y[j] - y[i] + 1), (y[i] - y[j] + 1))
      m[j, i] <- 1 / m[i, j]
    }
  }
  
  return(m)
}