#' @title Read an excel file containing the paired matrices
#' @name ler
#' @author Lyncoln Oliveira
#'
#' @description Function to read an excel file containing the paired matrices and turn all spreadsheets into a list of matrices in R.
#'
#' @param caminho Address to an excel file that contains the worksheets.
#'
#' @return Returns a list containing the matrices from the excel file.
#'
#' @examples
#' # Criando um arquivo de exemplo para o teste
#' library(openxlsx)
#' tmp <- tempfile(fileext = ".xlsx")
#' m <- matrix(c(1, 2, 0.5, 1), nrow = 2)
#' openxlsx::write.xlsx(list(Sheet1 = m), file = tmp)
#' 
#' # Testando a função
#' lista = ler(tmp)
#' lista
#'
#' @importFrom readxl excel_sheets read_excel
#' @importFrom openxlsx write.xlsx
#' @export

ler = function(caminho) {
  # Obtém os nomes das abas
  planilhas = readxl::excel_sheets(caminho)
  
  # Lê cada aba e transforma em matriz
  matrizes = lapply(planilhas, function(x) {
    df = readxl::read_excel(path = caminho, col_names = FALSE, sheet = x)
    as.matrix(df) # Garante que retorne uma matriz e não um tibble
  })
  
  names(matrizes) = planilhas
  return(matrizes)
}