% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_mh.R
\docType{data}
\name{vars_mh_p_eatq__actv}
\alias{vars_mh_p_eatq__actv}
\alias{compute_mh_p_eatq__actv_mean}
\title{Compute "Early Adolescent Temperament Questionnaire [Parent] (Activation):
Mean "}
\format{
vars_mh_p_eatq__actv is a character vector of all column names
used to compute summary score of \code{mh_p_eatq__actv_mean}.
}
\usage{
vars_mh_p_eatq__actv

compute_mh_p_eatq__actv_mean(
  data,
  name = "mh_p_eatq__actv_mean",
  max_na = 1,
  combine = TRUE,
  revert = FALSE
)
}
\arguments{
\item{data}{tbl, Dataframe containing the columns to be summarized.}

\item{name}{character, Name of the new column to be created. Default is
the name in description, but users can change it.}

\item{max_na}{integer, Maximum number of missing values allowed in the
summary score. \code{NULL} means no limit.}

\item{combine}{logical, If \code{TRUE}, the summary score will be appended to
the input data frame. If \code{FALSE}, the summary score will be returned as a
separate data frame.}

\item{revert}{logical, If \code{TRUE}, the summary score will be reverse scored.}
}
\value{
tbl. The input data frame with the summary score appended as
a new column.
}
\description{
Computes the summary score \code{mh_p_eatq__actv_mean}
Early Adolescent Temperament Questionnaire [Parent] (Activation): Mean
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{mh_p_eatq__actv_001}
\item \code{mh_p_eatq__actv_002}
\item \code{mh_p_eatq__actv_003}
\item \code{mh_p_eatq__actv_004}
\item \code{mh_p_eatq__actv_005}
\item \code{mh_p_eatq__actv_006}
\item \code{mh_p_eatq__actv_007}
}
\item \emph{Excluded values:} none
\item \emph{Validation criterion:} maximally 1 of 7 items missing
}
}
\examples{
\dontrun{
data <- compute_mh_p_eatq__actv_mean(data)
select(
  data,
  any_of(c("mh_p_eatq__actv_mean", vars_mh_p_eatq__actv))
)
}

}
\keyword{datasets}
