% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_mh.R
\docType{data}
\name{vars_mh_p_ders__distract}
\alias{vars_mh_p_ders__distract}
\alias{compute_mh_p_ders__distract_mean}
\title{Compute "Difficulties in Emotion Regulation Scale [Parent] (Distracted):
Mean"}
\format{
\code{vars_mh_p_ders__distract} is vector of all column names
used to compute summary score of \code{mh_p_ders__distract} scores.
}
\usage{
vars_mh_p_ders__distract

compute_mh_p_ders__distract_mean(
  data,
  name = "mh_p_ders__distract_mean",
  max_na = 0,
  exclude = c("999", "777"),
  combine = TRUE
)
}
\arguments{
\item{data}{tbl. Data frame containing the columns to be summarized.}

\item{name}{character. Name of the summary score column.}

\item{max_na}{numeric, positive whole number. Number of missing items
allowed. \code{NULL} means no limit.}

\item{exclude}{character vector. Values to be excluded from the summary
score calculation.}

\item{combine}{logical. If \code{TRUE} (default), the summary score is
is appended as a new column to the input data frame. If \code{FALSE}, the
summary score is returned as a separate one-column data frame.}
}
\value{
tbl. see \code{combine}.
}
\description{
Computes the summary score \code{mh_p_ders__distract_mean}
Difficulties in Emotion Regulation Scale [Parent] (Distracted): Mean
\itemize{
\item \emph{Summarized variables:}
\itemize{
\item \code{mh_p_ders__distract_001}
\item \code{mh_p_ders__distract_002}
\item \code{mh_p_ders__distract_003}
\item \code{mh_p_ders__distract_004}
}
\item \emph{Excluded values:}
\itemize{
\item 999
\item 777
}
\item \emph{Validation criterion:} none of 4 items missing
}
}
\examples{
\dontrun{
compute_mh_p_ders__distract_mean(data) |>
  select(
    any_of(c("mh_p_ders__distract_mean", vars_mh_p_ders__distract))
  )
}
}
\keyword{datasets}
