% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reset_index_var.R
\name{reset_index_var}
\alias{reset_index_var}
\alias{reset_index_var.zoocat}
\title{Reset index variable of a \code{zoocat} object}
\usage{
reset_index_var(x, ...)

\method{reset_index_var}{zoocat}(x, index.var, ...)
}
\arguments{
\item{x}{the object.}

\item{...}{other arguments.}

\item{index.var}{the name of the variable to be set as the index. 
Must be one of the \code{cattr} field.}
}
\value{
a "\code{zoocat}" object.
}
\description{
Reset the index variable of a "\code{zoocat}" object to be one of the fields in 
the \bold{cattr} table.
}
\examples{

x <- matrix(1 : 20, nrow = 5)
colAttr <- data.frame(month = c(2, 3, 5, 6), name = c(rep('xxx', 3), 'yyy'))
zc <- zoocat(x, order.by = 1991 : 1995, colattr = colAttr)
print(zc)
reset_index_var(zc, 'month')
reset_index_var(zc, 'name')

}

