% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{flush_compressor_buffer}
\alias{flush_compressor_buffer}
\title{Flush the internal buffer of the compressor object.}
\usage{
flush_compressor_buffer(compressorPtr, mode = 4L)
}
\arguments{
\item{compressorPtr}{A SEXP pointer to an existing compressor object.}

\item{mode}{A compression flush mode. Default is Z_FINISH.
Available modes are Z_NO_FLUSH, Z_PARTIAL_FLUSH, Z_SYNC_FLUSH, Z_FULL_FLUSH, Z_BLOCK, and Z_FINISH.}
}
\value{
A raw vector containing the flushed output.
}
\description{
This function flushes the internal buffer according to the specified mode.
}
\examples{
compressor <- create_compressor()
# ... (some compression actions)
flushed_data <- flush_compressor_buffer(compressor)
}
