% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsmmfit_exp.R
\name{hsmmfit_exp}
\alias{hsmmfit_exp}
\title{Simulate a hidden semi-Markov series and its underlying states with covariates 
where the latent state distributions have accelerated failure time structure
whose base densities are exponential}
\usage{
hsmmfit_exp(y, M, trunc, dtrate, dtparm, prior, zeroparm, emitparm, tpmparm,
  dt_x, zeroinfl_x, emit_x, tpm_x, yceil = NULL, method = "Nelder-Mead",
  hessian = FALSE, ...)
}
\arguments{
\item{y}{observed time series values}

\item{M}{number of latent states}

\item{trunc}{a vector specifying truncation at the maximum number of dwelling time in 
each state.}

\item{dtrate}{a vector for the scale parameters in the base exponential
density for the latent state durations.}

\item{dtparm}{a matrix of coefficients for the accelerated failure time
model in each latent state}

\item{prior}{a vector of prior probabilities}

\item{zeroparm}{a vector of regression coefficients for the structural
zero proportion in state 1}

\item{emitparm}{a matrix of regression coefficients for the Poisson
regression in each state}

\item{tpmparm}{a vector of coefficients for the multinomial logistic
regression in the transition probabilities}

\item{dt_x}{a matrix of covariates for the latent state durations}

\item{zeroinfl_x}{a matrix of covariates for the zero proportion}

\item{emit_x}{a matrix of covariates for the Poisson means}

\item{tpm_x}{a matrix of covariates for the transition}

\item{yceil}{a scalar defining the ceiling of y, above which the values will be
truncated. Default to NULL.}

\item{method}{method to be used for direct numeric optimization. See details in
the help page for optim() function. Default to Nelder-Mead.}

\item{hessian}{Logical. Should a numerically differentiated Hessian matrix be returned?
Note that the hessian is for the working parameters, which are the generalized logit of prior 
probabilities (except for state 1), the generalized logit of the transition probability 
matrix(except 1st column), the logit of non-zero zero proportions, and the log of 
each state-dependent poisson means}

\item{...}{Further arguments passed on to the optimization methods}
}
\value{
the maximum likelihood estimates of the zero-inflated hidden Markov model
}
\description{
Simulate a hidden semi-Markov series and its underlying states with covariates 
where the latent state distributions have accelerated failure time structure
whose base densities are exponential
}
\references{
Walter Zucchini, Iain L. MacDonald, Roland Langrock. Hidden Markov Models for 
Time Series: An Introduction Using R, Second Edition. Chapman & Hall/CRC
}
