% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zi_zipfpss.R
\name{zi_zipfpss}
\alias{zi_zipfpss}
\alias{d_zi_zipfpss}
\title{The Zero Inflated Zipf-Poisson Stop Sum Distribution (ZI Zipf-PSS).}
\usage{
d_zi_zipfpss(x, alpha, lambda, w, log = FALSE)
}
\arguments{
\item{x}{Vector of positive integer values.}

\item{alpha}{Value of the \eqn{\alpha} parameter (\eqn{\alpha > 1} ).}

\item{lambda}{Value of the \eqn{\lambda} parameter (\eqn{\lambda > 0} ).}

\item{w}{Value of the \eqn{w} parameter (0 < \eqn{w < 1} ).}

\item{log}{Logical; if TRUE, probabilities p are given as log(p).}
}
\description{
Probability mass function for the zero inflated Zipf-PSS distribution with parameters \eqn{\alpha}, \eqn{\lambda} and \eqn{w}.
The support of thezero inflated Zipf-PSS distribution are the positive integer numbers including the zero value.
}
\details{
The support of the \eqn{\lambda} parameter increases when the distribution is truncated at zero being
\eqn{\lambda \geq 0}. It has been proved that when \eqn{\lambda = 0} one has the degenerated version of the distribution at one.
}
\references{
{
Panjer, H. H. (1981). Recursive evaluation of a family of compound
distributions. ASTIN Bulletin: The Journal of the IAA, 12(1), 22-26.

Sundt, B., & Jewell, W. S. (1981). Further results on recursive evaluation of
compound distributions. ASTIN Bulletin: The Journal of the IAA, 12(1), 27-39.
}
}
