% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/functions_package.R
\name{Zeta.scale.regular}
\alias{Zeta.scale.regular}
\title{Zeta diversity scaling with sample grain using hierarchically increases in grain size}
\usage{
Zeta.scale.regular(xy, data.spec, n, order = 1, sam = 1000, plot = TRUE)
}
\arguments{
\item{xy}{Site-by-coordinate data frame, with sites as rows and coordinates as columns.}

\item{data.spec}{Site-by-species presence-absence data frame, with sites as rows and species as columns.}

\item{n}{Vector of aggregation indices: regularly spaced sites are grouped as n[i] x n[i] sites.}

\item{order}{Specific number of assemblages or sites at which zeta diversity is computed.}

\item{sam}{Number of samples for which the zeta-diversity is computed.}

\item{plot}{Boolean value (TRUE or FALSE) indicating if the outputs must be plotted.}
}
\value{
\code{Zeta.scale.regular} returns a vector \code{zeta.scale.reg} containing the zeta-diversity values for each grain.
}
\description{
Computes zeta diversity scaling with sample grain for a specific order (number of assemblages or sites), increasing grain by hierarchically nesting of regularly spaced sites.
}
\details{
The sites (plots or quadrates) are incrementally aggregated as nearest neighbouring groups of 4, 9, etc. sites, using a nested approach, starting from the lowest x and y, to increase the grain. The sites can be spatially contiguous or discontiguous, as long as they are regularly spaced. This function is not suitable for irregularly spaced sites.
}
\examples{
data(BCI.spec.fine)
xy <- BCI.spec.fine[1:2]
data.spec <- BCI.spec.fine[3:308]

dev.new()
##sam = 25 is used here for fast execution, but a higher value is advised
zeta.scale.reg <- Zeta.scale.regular(xy, data.spec, n = 1:3, order = 3, sam = 25)
}
\references{
Hui C. & McGeoch M.A. (2014). Zeta diversity as a concept and metric that unifies incidence-based biodiversity patterns. \emph{The American Naturalist}, 184, 684-694.

Scheiner S.M., Chiarucci A., Fox G.A., Helmus M.R., McGlinn D.J. & Willig M.R. (2011). The underpinnings of the relationship of species richness with space and time. \emph{Ecological Monographs}, 81, 195-213.
}
\seealso{
\code{\link{Zeta.decline}}, \code{\link{Zeta.order}}, \code{\link{Zeta.scale.min.dist}}
}

