% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot2dgraphics.R
\name{axes_2d_graphics}
\alias{axes_2d_graphics}
\title{Axes arrows in 2d using R's base graphics}
\usage{
axes_2d_graphics(zargs, length = 0.1, eps = 0.04, code = 2,
  xpd = NA, add = FALSE, group... = NULL, plot... = NULL, ...)
}
\arguments{
\item{zargs}{argument list as passed from \code{\link{zenplot}()}}

\item{length}{length of the arrow head}

\item{eps}{distance by which the axes are moved away from the plot region}

\item{code}{integer code determining the kind of arrows to be drawn; see ?arrows}

\item{xpd}{logical or NA, determining the region with respect to which clipping
takes place; see ?par}

\item{add}{logical indicating whether this plot should be added to the last one}

\item{group...}{list of arguments passed to group_2d_graphics (or NULL)}

\item{plot...}{additional arguments passed to plot_region()}

\item{...}{additional arguments passed to points()}
}
\value{
invisible()
}
\description{
Axes arrows in 2d using R's base graphics
}
\note{
Inspired by https://stat.ethz.ch/pipermail/r-help/2004-October/059525.html
}
\seealso{
Other default 2d plot functions using R's base graphics: \code{\link{arrow_2d_graphics}},
  \code{\link{density_2d_graphics}},
  \code{\link{group_2d_graphics}},
  \code{\link{label_2d_graphics}},
  \code{\link{points_2d_graphics}},
  \code{\link{qq_2d_graphics}},
  \code{\link{rect_2d_graphics}}

Other default 2d plot functions: \code{\link{arrow_2d_graphics}},
  \code{\link{arrow_2d_grid}}, \code{\link{arrow_2d_loon}},
  \code{\link{axes_2d_grid}}, \code{\link{axes_2d_loon}},
  \code{\link{density_2d_graphics}},
  \code{\link{density_2d_grid}},
  \code{\link{density_2d_loon}}, \code{\link{extract_2d}},
  \code{\link{group_2d_graphics}},
  \code{\link{group_2d_grid}}, \code{\link{group_2d_loon}},
  \code{\link{label_2d_graphics}},
  \code{\link{label_2d_grid}}, \code{\link{label_2d_loon}},
  \code{\link{points_2d_graphics}},
  \code{\link{points_2d_grid}},
  \code{\link{points_2d_loon}},
  \code{\link{qq_2d_graphics}}, \code{\link{qq_2d_grid}},
  \code{\link{rect_2d_graphics}},
  \code{\link{rect_2d_grid}}, \code{\link{rect_2d_loon}}
}
\author{
Marius Hofert and Wayne Oldford
}
\concept{default 2d plot functions}
\concept{default 2d plot functions using R's base graphics}
