% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json.R
\name{read_json_raw}
\alias{read_json_raw}
\title{Convert JSON in a raw vector to R}
\usage{
read_json_raw(raw_vec, opts = list(), ...)
}
\arguments{
\item{raw_vec}{raw vector}

\item{opts}{Named list of options for parsing. Usually created by \code{opts_read_json()}}

\item{...}{Other named options can be used to override any options in \code{opts}.
The valid named options are identical to arguments to \code{\link[=opts_read_json]{opts_read_json()}}}
}
\value{
R object
}
\description{
Convert JSON in a raw vector to R
}
\examples{
raw_str <- as.raw(utf8ToInt('[1, 2, 3, "four"]'))
read_json_raw(raw_str)
}
\seealso{
Other JSON Parsers: 
\code{\link{read_json_conn}()},
\code{\link{read_json_file}()},
\code{\link{read_json_str}()}
}
\concept{JSON Parsers}
