% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{ypr_plot_fish}
\alias{ypr_plot_fish}
\title{Plot Fish}
\usage{
ypr_plot_fish(
  population,
  x = "Age",
  y = "Survivors",
  percent = FALSE,
  binwidth = 1L,
  color = NULL
)
}
\arguments{
\item{population}{An object of class \code{\link[=ypr_population]{ypr_population()}}.}

\item{x}{A string of the term on the x-axis.}

\item{y}{A string of the term on the y-axis.}

\item{percent}{A flag specifying whether to plot the number of fish as a percent or frequency (the default).}

\item{binwidth}{A positive integer of the width of the bins for grouping.}

\item{color}{A string of the color around each bar (or NULL).}
}
\value{
A ggplot2 object.
}
\description{
Produces a frequency histogram of the number of fish in the
'Survivors', 'Spawners', 'Caught', 'Harvested' or 'Released' categories by
'Length', 'Age' or 'Weight' class.
}
\examples{
ypr_plot_fish(ypr_population(), color = "white")
}
\seealso{
\code{\link[=ypr_population]{ypr_population()}} and \code{\link[ggplot2:geom_histogram]{ggplot2::geom_histogram()}}
}
