% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teamBowlingWicketRunsAllOppnAllMatches.R
\name{teamBowlingWicketRunsAllOppnAllMatches}
\alias{teamBowlingWicketRunsAllOppnAllMatches}
\title{Team bowling wicket runs all matches against all oppositions}
\usage{
teamBowlingWicketRunsAllOppnAllMatches(matches,t1,t2="All",plot=TRUE)
}
\arguments{
\item{matches}{The matches of the team against all oppositions and all matches}

\item{t1}{Team for which bowling performance is required}

\item{t2}{t2=All gives the performance of the team against all opponents. Giving a opposing team (Australia, India
) will give the performance against this  team}

\item{plot}{If plot= TRUE the dataframe will be plotted else a data frame will be returned}
}
\value{
None or data fame
A data frame with the bowling performance in alll matches against all oppositions
}
\description{
This function computes the number of wickets and runs conceded by bowlers in all matches against
all oppositions. The user can chose to plot or return a data frame
}
\note{
Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
}
\examples{
\dontrun{
#Get all matches between India  and other opposition
matches <-getAllMatchesAllOpposition("India",dir="../data/",save=TRUE)

# Or load directly from saved file
# load("allMatchesAllOpposition-India.RData")

teamBowlingWicketRunsAllOppnAllMatches(matches,t1="India",t2="All",plot=TRUE)
m <-teamBowlingWicketRunsAllOppnAllMatches(matches,t1="India",t2="All",plot=FALSE)
}

}
\author{
Tinniam V Ganesh
}
\references{
\url{http://cricsheet.org/}\cr
\url{https://gigadom.wordpress.com/}\cr
\url{https://github.com/tvganesh/yorkrData}
}
\seealso{
\code{\link{teamBowlingScorecardAllOppnAllMatchesMain}}\cr
\code{\link{teamBowlersVsBatsmenAllOppnAllMatchesMain}}\cr
\code{\link{teamBowlersVsBatsmenAllOppnAllMatchesPlot}}\cr
}

