% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popover.R
\name{popover}
\alias{popover}
\alias{showPopover}
\alias{closePopover}
\title{Popovers}
\usage{
popover(..., title = NULL)

showPopover(
  id,
  popover,
  placement = "top",
  duration = NULL,
  session = getDefaultReactiveDomain()
)

closePopover(id, session = getDefaultReactiveDomain())
}
\arguments{
\item{...}{Character strings or tag elements specifying the content of the
popover or additional named arguments passed as HTML attributes to the
parent element.}

\item{title}{A character string specifying a title for the popover, defaults
to \code{NULL}, in which case a title is not added.}

\item{id}{A character string specifying the id of a popover's target tag
element.}

\item{popover}{The popover element to show, typically a call to \code{popover()}.}

\item{placement}{One of \code{"top"}, \code{"left"}, \code{"bottom"}, or \code{"right"}
specifying where the popover is positioned relative to the target tag
element indicated by \code{id}, defaults to \code{"top"}.}

\item{duration}{A positive integer specifying the duration of the popover in
seconds or \code{NULL}, in which case the popover is not automatically removed.
When \code{NULL} the popover must be removed with \code{closePopover()}.}

\item{session}{A reactive context, defaults to \code{\link[=getDefaultReactiveDomain]{getDefaultReactiveDomain()}}.}
}
\description{
Popovers are small windows of content associated with a tag element. Use
\code{popover()} to construct the element and \code{showPopover()} to add it to any tag
element with an HTML id. Popovers are great for explaining inputs and giving
hints to the users. Popovers are hidden with \code{closePopover()}.
}
\section{Example application}{
\if{html}{\out{<div class="R">}}\preformatted{ui <- container(
  buttonInput("showHelp", "Help!"),
  div(
    id = "textBlock1",
    "Sociis natoque penatibus et magnis"
  ) \%>\%
    padding(3)
) \%>\%
  display("flex") \%>\%
  flex(justify = "around")

server <- function(input, output) \{
  observeEvent(input$showHelp, ignoreInit = TRUE, \{
    showPopover(
      target = "textBlock1",
      popover(title = "Hint", "I am a <div> element!"),
      placement = "bottom",
      duration = 4
    )
  \})
\}

shinyApp(ui, server)
}\if{html}{\out{</div>}}
}

\examples{

### Examples

# Please see example application above.

}
\seealso{
Other components: 
\code{\link{alert}()},
\code{\link{badge}()},
\code{\link{blockquote}()},
\code{\link{card}()},
\code{\link{collapsePane}()},
\code{\link{d1}()},
\code{\link{dropdown}()},
\code{\link{img}()},
\code{\link{jumbotron}()},
\code{\link{modal}()},
\code{\link{navContent}()},
\code{\link{pre}()},
\code{\link{toast}()}
}
\concept{components}
