% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R
\name{active}
\alias{active}
\title{Selected choice color}
\usage{
active(tag, color)
}
\arguments{
\item{tag}{A tag element.}

\item{color}{One of \code{"red"}, \code{"purple"}, \code{"indigo"}, \code{"blue"}, \code{"cyan"},
\code{"teal"}, \code{"green"}, \code{"yellow"}, \code{"amber"}, \code{"orange"}, \code{"grey"}, \code{"white"}
specifying the active color of selected choices.}
}
\description{
Use \code{active()} to change the highlight color of an input's selected choices.
}
\examples{

### Radiobar example

radiobarInput(
  id = "radio1",
  choices = c("Hello", "Goodnight", "Howdy")
) \%>\%
  width(16) \%>\%
  active("orange")  # <-

### Checkbox example

checkboxInput(
  id = "check1",
  choices = c("Rock", "Paper", "Scissors"),
  selected = "Rock"
) \%>\%
  active("teal")

### Chip input

chipInput(
  id = "chip1",
  choices = c("Ether", "Bombos", "Quake"),
  selected = "Ether"
) \%>\%
  width("1/2") \%>\%
  active("green")

}
\seealso{
Other design utilities: 
\code{\link{affix}()},
\code{\link{background}()},
\code{\link{border}()},
\code{\link{display}()},
\code{\link{float}()},
\code{\link{font}()},
\code{\link{height}()},
\code{\link{padding}()},
\code{\link{scroll}()},
\code{\link{shadow}()},
\code{\link{width}()}
}
\concept{design utilities}
