% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list-group.R
\name{listGroupInput}
\alias{listGroupInput}
\alias{updateListGroupInput}
\title{List group inputs}
\usage{
listGroupInput(id, choices = NULL, values = choices, selected = NULL,
  ..., layout = "vertical", flush = FALSE)

updateListGroupInput(id, choices = NULL, values = choices,
  selected = NULL, enable = NULL, disable = NULL,
  session = getDefaultReactiveDomain())
}
\arguments{
\item{id}{A character string specifying the id of the reactive input.}

\item{choices}{A vector of character strings or list of tag elements specifying
the content of the list group's items.}

\item{values}{A character vector specifying the values of the list items,
defaults to \code{choices}.}

\item{selected}{One or more of \code{values} specifying which choices are selected
by default, defaults to \code{NULL}, in which case no choice is selected.}

\item{...}{Additional named arguments passed as HTML attributes to the
parent element or tag elements passed as child elements to the parent
element.}

\item{layout}{A \link{responsive} argument. One of \code{"vertical"} or \code{"horizontal"}
specifying how list items are laid out, defaults to \code{"vertical"}. Note, if
\code{layout} is \code{"horizontal"} and the \code{flush} argument is ignored.}

\item{flush}{One of \code{TRUE} or \code{FALSE} specifying if the list group is
rendered without an outside border, defaults to \code{FALSE}. Removing the list
group border is useful when rendering a list group inside a custom parent
container, e.g. inside a \code{\link[=card]{card()}}.}

\item{enable}{One of \code{values} specifying particular choices to enable or
\code{TRUE} specifying the entire input is enabled, defaults to \code{NULL}.}

\item{disable}{One of \code{values} specifying particular choices to disable or
\code{TRUE} specifying the entire input is disabled, defaults to \code{NULL}.}

\item{session}{A reactive context, defaults to \code{\link[=getDefaultReactiveDomain]{getDefaultReactiveDomain()}}.}
}
\description{
List group inputs are an actionable list of items. They behave similarly to
checkboxes or radios, that is, users may select one or more items from the
list. However, list group items may include highly variable content.
}
\section{Navigation with a list group}{


A list group can also control a set of panes. Be sure to set \code{multiple = FALSE}. This layout is reminiscent of a table of contents.\preformatted{ui <- container(
  columns(
    column(
      width = 3,
      listGroupInput(
        id = "nav",
        selected = "pane1",
        choices = c(
          "Item 1",
          "Item 2",
          "Item 3"
        ),
        values = c(
          "pane1",
          "pane2",
          "pane3"
        )
      )
    ),
    column(
      navContent(
        navPane(
          id = "pane1",
          p("Pellentesque tristique imperdiet tortor.")
        ),
        navPane(
          id = "pane2",
          p("Sed bibendum. Donec pretium posuere tellus.")
        ),
        navPane(
          id = "pane3",
          p("Pellentesque tristique imperdiet tortor.")
        )
      )
    )
  )
)

server <- function(input, output) {
  observeEvent(input$nav, {
    showPane(input$nav)
  })
}

shinyApp(ui, server)
}
}

\examples{

### An actionable list group

listGroupInput(
  id = "list1",
  choices = paste("Item", 1:5)
)

### List group within a card

card(
  header = h6("Pick an item"),
  listGroupInput(
    id = "list2",
    flush = TRUE,
    choices = paste("Item", 1:5),
  )
)

### Horizontal list group

listGroupInput(
  id = "list3",
  choices = paste("Item", 1:4),
  layout = "horizontal"
)

}
\seealso{
Other inputs: \code{\link{buttonGroupInput}},
  \code{\link{buttonInput}}, \code{\link{checkbarInput}},
  \code{\link{checkboxInput}}, \code{\link{chipInput}},
  \code{\link{fileInput}}, \code{\link{formInput}},
  \code{\link{menuInput}}, \code{\link{navInput}},
  \code{\link{radioInput}}, \code{\link{radiobarInput}},
  \code{\link{rangeInput}}, \code{\link{selectInput}},
  \code{\link{textInput}}
}
\concept{inputs}
