% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yml.R
\name{yml}
\alias{yml}
\alias{yml_empty}
\title{Create a new yml object}
\usage{
yml(.yml = NULL, get_yml = TRUE, author = TRUE, date = TRUE)

yml_empty()
}
\arguments{
\item{.yml}{a character vector, \code{yml} object, or YAML-like list. See details.}

\item{get_yml}{logical. Use YAML stored in
\code{getOption("ymlthis.default_option")}? By default, \code{yml()} includes if it
exists.}

\item{author}{logical. Get default author name?}

\item{date}{logical. Get default date?}
}
\value{
a \code{yml} object
}
\description{
\code{yml()} initializes a \code{yml} object. \code{yml} objects create valid YAML and print
it cleanly to the console. By default, \code{yml()} looks for your name (using \code{ getOption("usethis.full_name")}, \code{getOption("devtools.name")}, and
\code{whoami::fullname()}) and uses today's date to use in the \code{author} and \code{date}
fields, respectively. If you've set default YAML in
\code{getOption("ymlthis.default_option")} (see \code{\link[=use_yml_defaults]{use_yml_defaults()}}), \code{yml()}
will also use include those fields by default. \code{yml_empty()} is a wrapper
that doesn't use any of these default YAML fields. \code{yml()} and all
related\verb{yml_*()} functions validate that the results are indeed valid YAML
syntax, although not every function is able to check that the input fields
are valid for the setting they are used in.
}
\details{
\code{.yml} accepts a character vector of YAML, such as "author: Hadley Wickham",
an object returned by ymlthis functions that start with \verb{yml_*()}, or a
\code{list} object (e.g. \code{list(author = "Hadley Wickham")}). \code{.yml} objects are
processed with \code{\link[=as_yml]{as_yml()}}, a wrapper around \code{\link[yaml:yaml.load]{yaml::yaml.load()}}. See that
function for more details.
}
\examples{

yml()

yml(date = FALSE)

"author: Hadley Wickham\\ndate: 2014-09-12" \%>\%
  yml() \%>\%
  yml_title("Tidy Data") \%>\%
  yml_keywords(
    c("data cleaning", "data tidying", "relational databases", "R")
  )
\donttest{
yml() %>%
  yml_author(
    c("Yihui Xie", "Hadley Wickham"),
    affiliation = rep("RStudio", 2)
  ) %>%
  yml_date("07/04/2019") %>%
  yml_output(
    pdf_document(
    keep_tex = TRUE,
    includes = includes2(after_body = "footer.tex")
   )
  ) %>%
  yml_latex_opts(biblio_style = "apalike")
}
}
