% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggready.R
\name{ggready}
\alias{ggready}
\title{Prepare Data for GGplot}
\usage{
ggready(x, ...)
}
\arguments{
\item{x}{object}

\item{...}{passed arguments}
}
\value{
see methods
}
\description{
Prepares data for ggplot.
Generic, with methods for data.frame, and decorated.
}
\examples{
file <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
x <- decorate(file)
decorations(x, Weight)
decorations(as.data.frame(x), Weight) # downgrade still has attributes
class(x)
class(ggready(as.data.frame(x)))
class(ggready(x))
class(ggready(resolve(x)))
x <- ggready(x)
library(magrittr)
library(ggplot2)

# Here we filter on-the-fly
# without loss of attributes.
# Notice mg/L rendering; this is actually part of an expression.
file \%>\%
 decorate \%>\%
 filter(!is.na(conc)) \%>\%
 ggready \%>\%
 ggplot(aes(x = time, y = conc, color = Heart)) +
 geom_point()

# By default ggready resolves everything that is decorated.
# But we can intervene to resolve selectively,
# And further intervene to 'ggready' selectively.
#
x <- file \%>\% decorate \%>\% filter(!is.na(conc))
x \%>\%
resolve(conc, time) \%>\%   # Heart left unresolved!
ggready(conc, Heart, resolve = FALSE) \%>\%  # time left unreadied!
ggplot(aes(x = time, y = conc, color = Heart)) + geom_point()

# Still, all the labels were actually expressions:
x \%>\%
resolve(conc, time) \%>\%
ggready(conc, Heart, resolve = FALSE) \%>\%
decorations(conc, time, Heart)
}
\seealso{
Other ggready: 
\code{\link{ggready.data.frame}()},
\code{\link{ggready.decorated}()}
}
\concept{ggready}
\keyword{internal}
