% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desolve.R
\name{desolve.decorated}
\alias{desolve.decorated}
\title{Desolve Guide for Decorated}
\usage{
\method{desolve}{decorated}(x, ...)
}
\arguments{
\item{x}{decorated}

\item{...}{passed to \code{\link{drop_title}}, \code{\link{unclassified}}, and \code{\link{implicit_guide}}}
}
\value{
decorated
}
\description{
Un-resolves explicit usage of default key 'guide' to
implicit usage for 'decorated' class.
Simply calls 
\code{\link{drop_title}}, 
\code{\link{unclassified}},
and \code{\link{implicit_guide}}.
}
\examples{
library(magrittr)
file <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
x <- decorate(file)

# this is how Age, glyco, Race look when resolved
x \%>\% resolve \%>\% decorations(Age, glyco, Race)

# we can resolve two of them and then 'unresolve' all of them
x \%>\% resolve(glyco, Race) \%>\% desolve \%>\% decorations(Age, glyco, Race)
}
\seealso{
Other resolve: 
\code{\link{desolve.classified}()},
\code{\link{desolve.data.frame}()},
\code{\link{desolve.dvec}()},
\code{\link{desolve}()},
\code{\link{resolve.classified}()},
\code{\link{resolve.data.frame}()},
\code{\link{resolve.decorated}()},
\code{\link{resolve.dvec}()},
\code{\link{resolve}()}

Other interface: 
\code{\link{canonical.decorated}()},
\code{\link{classified.data.frame}()},
\code{\link{decorate.character}()},
\code{\link{decorate.data.frame}()},
\code{\link{ggplot.decorated}()},
\code{\link{io_csv.character}()},
\code{\link{io_csv.data.frame}()},
\code{\link{io_res.character}()},
\code{\link{io_res.decorated}()},
\code{\link{io_table.character}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{is_parseable.default}()},
\code{\link{mimic.default}()},
\code{\link{modify.default}()},
\code{\link{promote.list}()},
\code{\link{read_yamlet}()},
\code{\link{resolve.decorated}()},
\code{\link{scripted.default}()},
\code{\link{selected.default}()},
\code{\link{write_yamlet}()}
}
\concept{interface}
\concept{resolve}
