% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_table.R
\name{io_table.character}
\alias{io_table.character}
\title{Import Documented Table}
\usage{
\method{io_table}{character}(x, ext = getOption("yamlet_extension", ".yaml"), meta = NULL, ...)
}
\arguments{
\item{x}{character file path; passed to \code{\link{read.table}}}

\item{ext}{extension for metadata equivalent of x}

\item{meta}{explicit file path for metadata}

\item{...}{passed to \code{\link{read.table}} (if accepted) and to \code{\link{decorate}}}
}
\value{
data.frame
}
\description{
Imports a documented table.
A wrapper for read.table() that also
reads associated yamlet metadata, if present, and applies it
as attributes.
}
\examples{
example(io_table)
}
\seealso{
Other io: 
\code{\link{io_csv.character}()},
\code{\link{io_csv.data.frame}()},
\code{\link{io_csv}()},
\code{\link{io_res.character}()},
\code{\link{io_res.decorated}()},
\code{\link{io_res}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_table}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{io_yamlet.yamlet}()},
\code{\link{io_yamlet}()}

Other interface: 
\code{\link{canonical.decorated}()},
\code{\link{classified.data.frame}()},
\code{\link{decorate.character}()},
\code{\link{decorate.data.frame}()},
\code{\link{desolve.decorated}()},
\code{\link{ggplot.decorated}()},
\code{\link{io_csv.character}()},
\code{\link{io_csv.data.frame}()},
\code{\link{io_res.character}()},
\code{\link{io_res.decorated}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{is_parseable.default}()},
\code{\link{mimic.default}()},
\code{\link{modify.default}()},
\code{\link{promote.list}()},
\code{\link{read_yamlet}()},
\code{\link{resolve.decorated}()},
\code{\link{selected.default}()},
\code{\link{write_yamlet}()}
}
\concept{interface}
\concept{io}
\keyword{internal}
