% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explicit_guide.R
\name{implicit_guide.data.frame}
\alias{implicit_guide.data.frame}
\title{Coerce Data Frame Guide to Something More Implicit}
\usage{
\method{implicit_guide}{data.frame}(x, ...)
}
\arguments{
\item{x}{data.frame}

\item{...}{named arguments ignored; un-named arguments limit scope}
}
\value{
data.frame
}
\description{
Coerces data.frame guide-like attributes to 'guide'.
The attribute 'guide' generally suggests a guide
to interpretation of a data item, such as units, formats, codelists,
and encodings.  The idea here is to replace these with 'guide':
i.e., to undo the effects of \code{\link{explicit_guide.data.frame}}.
If guide attribute is still present, the explicit attribute is removed.
Otherwise the explicit element is renamed.
}
\examples{
library(magrittr)
x <- data.frame(
 ID = 1,
 CONC = 1,
 RACE = 1,
 SEX = 1,
 DATE = 1
)
x \%<>\% modify(ID, label = 'subject identifier')
x \%<>\% modify(CONC, label = 'concentration', guide = 'ng/mL')
x \%<>\% modify(RACE, label = 'race', guide = list(white = 0, black = 1, asian = 2))
x \%<>\% modify(SEX, label = 'sex', guide = list(female = 0, male = 1))
x \%<>\% modify(DATE, label  = 'date', guide = '\%Y-\%m-\%d')
x \%>\% decorations
x \%>\% explicit_guide \%>\% decorations
x \%>\% explicit_guide \%>\% implicit_guide \%>\% decorations
x \%>\% explicit_guide \%>\% implicit_guide(DATE) \%>\% decorations # limit scope
x \%>\% explicit_guide(simplify = FALSE) \%>\% decorations
x \%>\% explicit_guide(simplify = FALSE) \%>\% implicit_guide \%>\% decorations
}
\seealso{
Other explicit_guide: 
\code{\link{explicit_guide.data.frame}()},
\code{\link{explicit_guide.dvec}()},
\code{\link{explicit_guide.yamlet}()},
\code{\link{explicit_guide}()},
\code{\link{implicit_guide.dvec}()},
\code{\link{implicit_guide}()},
\code{\link{infer_guide}()}
}
\concept{explicit_guide}
\keyword{internal}
