% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assembly.R
\name{ata}
\alias{ata}
\alias{ata.constraint}
\alias{ata.fixitem}
\alias{ata.maxselect}
\alias{ata.obj.abs}
\alias{ata.obj.rel}
\alias{ata.solve}
\alias{print.ata}
\title{Automated Test Assembly}
\usage{
ata(pool, nform)

\method{print}{ata}(x, ...)

ata.obj.rel(x, value, mode, negative.obj = FALSE, forms = NULL)

ata.obj.abs(x, value, target, forms = NULL)

ata.constraint(x, var, level, min, max, forms = NULL)

ata.maxselect(x, maxselect, items = NULL)

ata.fixitem(x, value, items, forms = NULL)

ata.solve(x, ...)
}
\arguments{
\item{pool}{an item pool (data.frame)}

\item{nform}{the number of forms to assemble}

\item{x}{the ata object}

\item{...}{further arguments}

\item{value}{a variable name, a theta point, or a vector of numeric values for all items}

\item{mode}{min for minimization and max for maximization}

\item{negative.obj}{TRUE if the objective function is epected to have a negative value}

\item{forms}{a vector of form where objective function is added}

\item{target}{the target value of the objective function}

\item{var}{the variable used to create constraint, and use "len" to add test length constraint}

\item{level}{a level value for categorical variable, and \code{NA} or \code{NULL} for continuous varialbe}

\item{min}{the minimum value}

\item{max}{the maximum value}

\item{maxselect}{the maximum times of selection}

\item{items}{a vector of item index}
}
\value{
\code{ata} returns an \code{ata} object
}
\description{
\code{ata} creates a autmoated test assemlby (ATA) object

\code{ata.obj.rel} adds an relative (maximize/minimize) objective function to LP

\code{ata.obj.abs} adds an absolute objective function to LP

\code{ata.maxselect} sets the maximum selection for items

\code{ata.fixitem} set a fixed value for items, e.g, 1 for selection and 0 for no selection

\code{ata.solve} solves the LP and returns results
}
\details{
An \code{ata} object contains \code{pool} (item pool), \code{nitem} (number of items in the pool),
\code{nform} (number of forms), \code{nlpitem} (number of item-related decision variables in LP), 
\code{nlp} (number of all decision variables), \code{lp} (the LP object), 
\code{rs.index} (indices of assembled items, if LP is solved), \code{rs.items} (assembled items, if LP is solved)

\code{ata.obj.rel}: For maximization problem, if obj.fn > 0, maximize y while obj.fn - y >= 0.
If obj.fn < 0, minimize y while obj.fn + y >= 0. For minimization problem, if obj.fn > 0,
minimize y while obj.fn - y <= 0. If obj.fn < 0, maximize y while obj.fn + y <= 0. \cr

\code{ata.obj.abs} minimizes y while obj.fn + y >= target and obj.fn - y <= target. \cr

In \code{ata.solve}, the \code{...} are additional \code{lp.control.options}
}
\examples{
pool <- gen.irt(1, 100)$items
pool$content <- sample(1:3, nrow(pool), replace=TRUE)
pool$time <- round(exp(rnorm(nrow(pool), log(20), .1)))
# assemble two 10-item forms to maximize information at theta=(-.5, .5)
x <- ata(pool, 2)
x <- ata.maxselect(x, 1)
x <- ata.constraint(x, "len", NA, 10, 10)
x <- ata.obj.rel(x, -0.5, "max")
x <- ata.obj.rel(x,  0.5, "max")
x <- ata.solve(x)
y1 <- x$rs.items[[1]]
y2 <- x$rs.items[[2]]
y1
y2
with(y1, plot(irt(c(-.5, .5), a, b, c), type="information"))
with(y2, plot(irt(c(-.5, .5), a, b, c), type="information"))
# assemble two 10-item forms to maximize difficulty without any items from content 1
x <- ata(pool, 2)
x <- ata.maxselect(x, 1)
x <- ata.constraint(x, "len", NA, 10, 10)
x <- ata.constraint(x, "content", 1, 0, 0)
x <- ata.obj.rel(x, "b", "max")
x <- ata.solve(x)
y1 <- x$rs.items[[1]]
y2 <- x$rs.items[[2]]
with(y1, plot(irt(0, a, b, c), type="information"))
with(y2, plot(irt(0, a, b, c), type="information"))
# assemble two 10-item forms to have have information (3.5, 3.5, 3.5) at (-.5, 0, .5)
x <- ata(pool, 2)
x <- ata.maxselect(x, 1)
x <- ata.constraint(x, "len", NA, 10, 10)
x <- ata.obj.abs(x, -0.5, 3.5)
x <- ata.obj.abs(x,  0.0, 3.5)
x <- ata.obj.abs(x,  0.5, 3.5)
x <- ata.solve(x)
y1 <- x$rs.items[[1]]
y2 <- x$rs.items[[2]]
with(y1, plot(irt(c(-.5,0,.5),a,b,c), type="information"))
with(y2, plot(irt(c(-.5,0,.5),a,b,c), type="information"))
# assemble two 10-item forms in which mean(b)=1, sd(b)=1
x <- ata(pool, 2)
x <- ata.maxselect(x, 1)
x <- ata.constraint(x, "len", NA, 10, 10)
x <- ata.obj.abs(x, "b", 1.0 * 10)
x <- ata.obj.abs(x, (pool$b-1.0)^2, 1.0 * 10)
x <- ata.solve(x)
y1 <- x$rs.items[[1]]
mean(y1$b)
sd(y1$b)
y2 <- x$rs.items[[2]]
mean(y2$b)
sd(y2$b)
x$rs.items
with(y1, plot(irt(0, a, b, c), type="information"))
with(y2, plot(irt(0, a, b, c), type="information"))
}

