% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.xtune}
\alias{predict.xtune}
\title{Model predictions based on fitted \code{xtune} object}
\usage{
\method{predict}{xtune}(object, newX, type = c("response", "class"),
  X = NULL, Y = NULL, ...)
}
\arguments{
\item{object}{Fitted 'xtune' model object.}

\item{newX}{Matrix of values at which predictions are to be made.}

\item{type}{Type of prediction required. For "linear" models it gives the fitted values. Type "response" gives the fitted probability scores for "binary" outcome.  Type "class" applies only to "binary" models, and produces the class label corresponding to the maximum probability.
Note that with type = "class", it is required to supply the original X =  and Y = as additional arguments to \code{predict()}.}

\item{X}{Passing arguments \code{X= } when \code{type = class}}

\item{Y}{Passing arguments \code{Y= } when \code{type = class}}

\item{...}{Not used}
}
\value{
A vector of predictions
}
\description{
\code{predict.xtune} produces predicted values fitting an xtune model to a new dataset
}
\details{
\code{coef} and \code{predict} methods are provided as a convenience to extract coefficients and make prediction. \code{predict.xtune} simply calculate the predicted value using the estimated coefficients returned by \code{xtune}.
}
\examples{
## simulate data
set.seed(9)
data(example)
X <- example$X
Y <- example$Y
Z <- example$Z

## If no Z provided, perform Empirical Bayes tuning
# fit.eb <- xtune(X,Y)
## Coef and predict methods
#coef(fit.eb)
# predict(fit.eb,X)

## Differential shrinkage based on external information Z:
fit.diff <- xtune(X,Y,Z)
## Coef and predict methods
coef(fit.diff)
predict(fit.diff,X)
}
\seealso{
\code{xtune}, \code{coef.xtune}
}
