% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xrf.R
\name{coef.xrf}
\alias{coef.xrf}
\title{Produce rules & coefficients for the RuleFit model}
\usage{
\method{coef}{xrf}(object, lambda = "lambda.min", ...)
}
\arguments{
\item{object}{an object of class "xrf"}

\item{lambda}{the lasso penalty parameter to be applied as in 'glmnet'}

\item{...}{ignored arguments}
}
\description{
Produce rules & coefficients for the RuleFit model
}
\examples{
m <- xrf(Petal.Length ~ ., iris,
         xgb_control = list(nrounds = 2, max_depth = 2),
         family = 'gaussian')
linear_model_coefficients <- coef(m, lambda = 'lambda.1se')

}
