% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.absval.R, R/add.dichot.R, R/add.exp.R,
%   R/add.log.R, R/add.tad.R
\name{add_transformed_columns}
\alias{add_transformed_columns}
\alias{add.absval}
\alias{add.dichot}
\alias{add.exp}
\alias{add.log}
\alias{add.tad}
\title{Column-transformation functions for Xpose 4}
\usage{
add.absval(object, listall = TRUE, classic = FALSE)

add.dichot(object, listall = TRUE, classic = FALSE)

add.exp(object, listall = TRUE, classic = FALSE)

add.log(object, listall = TRUE, classic = FALSE)

add.tad(object, classic = FALSE)
}
\arguments{
\item{object}{An \code{xpose.data} object.}

\item{listall}{A logical operator specifying whether the items in the
database should be listed.}

\item{classic}{A logical operator specifying whether the function should
assume the classic menu system.  This is an internal option and need never
be called from the command line.}
}
\value{
An \code{\link{xpose.data}} object (classic == FALSE) or null
(classic == TRUE).
}
\description{
These functions transform existing Xpose 4 data columns, adding new columns.
}
\details{
These functions may be used to create new data columns within the Xpose data
object by transforming existing ones.
}
\section{Functions}{
\itemize{
\item \code{add.absval}: Create a column containing the absolute values of data 
in another column.

\item \code{add.dichot}: Create a categorical data column based on a continuous data column

\item \code{add.exp}: Create an exponentiated version of an existing variable

\item \code{add.log}: Create a log transformation of an existing variable

\item \code{add.tad}: Create a time-after-dose
(TAD) data item based upon the dose and time variables in the dataset.
}}

\examples{

\dontrun{
## xpdb5 is an Xpose data object
## We expect to find the required NONMEM run and table files for run
## 5 in the current working directory
xpdb5 <- xpose.data(5)

## Create a column containing the absolute values of data in another 
## column
add.absval(xpdb5)

## Create a categorical data column based on a continuous data column, 
## and do not list variables 
add.dichot(xpdb5, listall = FALSE)

## Create a column containing the exponentiated values of data in 
## another column
add.exp(xpdb5)

## Create a column containing log-transformations of data in another 
## column
add.log(xpdb5)

## Create a time-after-dose column
add.tad(xpdb5)
}

}
\seealso{
\code{\link{xpose.data}}

Other data functions: 
\code{\link{change_graphical_parameters}},
\code{\link{change_misc_parameters}},
\code{\link{compute.cwres}()},
\code{\link{data.checkout}()},
\code{\link{data_extract_or_assign}},
\code{\link{db.names}()},
\code{\link{export.graph.par}()},
\code{\link{export.variable.definitions}()},
\code{\link{import.graph.par}()},
\code{\link{import.variable.definitions}()},
\code{\link{make.sb.data}()},
\code{\link{nsim}()},
\code{\link{par_cov_summary}},
\code{\link{read.TTE.sim.data}()},
\code{\link{read.nm.tables}()},
\code{\link{read_NM_output}},
\code{\link{read_nm_table}()},
\code{\link{simprazExample}()},
\code{\link{tabulate.parameters}()},
\code{\link{xlabel}()},
\code{\link{xpose.data}},
\code{\link{xpose.print}()},
\code{\link{xpose4-package}},
\code{\link{xsubset}()}
}
\author{
Niclas Jonsson, Justin Wilkins and Andrew Hooker
}
\concept{data functions}
