% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xp.scope3.R
\name{xp.scope3}
\alias{xp.scope3}
\title{Define a scope for the gam.  Used as default input to the \code{scope} argument in 
\code{xpose.gam}}
\usage{
xp.scope3(object, covnam = xvardef("covariates", object), nmods = 3,
  smoother1 = 0, arg1 = NULL, smoother2 = 1, arg2 = NULL,
  smoother3 = "ns", arg3 = "df=2", smoother4 = "ns", arg4 = "df=3",
  excl1 = NULL, excl2 = NULL, excl3 = NULL, excl4 = NULL,
  extra = NULL, subset = xsubset(object), ...)
}
\arguments{
\item{object}{An xpose.data object.}

\item{covnam}{Covariate names to test.}

\item{nmods}{Number of models to examine.}

\item{smoother1}{Smoother for each model.}

\item{arg1}{Argument for model 1.}

\item{smoother2}{Smoother for each model.}

\item{arg2}{Argument for model 2.}

\item{smoother3}{Smoother for each model.}

\item{arg3}{Argument for model 3.}

\item{smoother4}{Smoother for each model.}

\item{arg4}{Argument for model 4.}

\item{excl1}{Covariate exclusion from model 1.}

\item{excl2}{Covariate exclusion from model 2.}

\item{excl3}{Covariate exclusion from model 3.}

\item{excl4}{Covariate exclusion from model 4.}

\item{extra}{Extra exclusion criteria.}

\item{subset}{Subset on data.}

\item{...}{Used to pass arguments to more basic functions.}
}
\description{
Define a scope for the gam.  Used as default input to the \code{scope} argument in 
\code{xpose.gam}
}
\examples{

xp.scope3(simpraz.xpdb)

}
\seealso{
Other GAM functions: \code{\link{GAM_summary_and_plot}},
  \code{\link{xp.get.disp}}, \code{\link{xpose.bootgam}},
  \code{\link{xpose.gam}}, \code{\link{xpose4-package}}
}
