% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_parameters.R
\name{transform_prm}
\alias{transform_prm}
\title{Mean and variance of tranformed parameters}
\usage{
transform_prm(formula, mu, sigma, method = "delta", samples = 1000)
}
\arguments{
\item{formula}{A formula describing the transformation.}

\item{mu}{Vector of mean values for the variables in formula.}

\item{sigma}{Covariance matrix for the variables in formula.}

\item{method}{A string indicating which method to use for the calculation.}

\item{samples}{Number of Monte-Carlo samples for method "mc"}
}
\value{
A list with entries `mean`, `variance` and `rse`
}
\description{
The function calculates the mean and variance of function of parameters
}
\examples{
# Mean, variance and rse for sqrt of variable with mean 1 and variance 0.01
transform_prm(~sqrt(a), mu = c(a = 1), sigma = c(a = 0.01))

}
\keyword{internal}
