% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xpdb_access.R
\name{get_data}
\alias{get_data}
\title{Access model output table data}
\usage{
get_data(xpdb, table = NULL, .problem = NULL, quiet)
}
\arguments{
\item{xpdb}{An \code{xpose_data} object from which the model output file data will be extracted.}

\item{table}{Name of the output table to be extracted from the xpdb e.g. 'sdtab001'. Alternative to 
the `.problem` argument.}

\item{.problem}{Accesses all tables from the specified problem. Alternative to the `table` argument.}

\item{quiet}{Logical, if \code{FALSE} messages are printed to the console.}
}
\value{
By default returns data from the last estimation problem. If only simulation problems are present 
then the data from last simulation will be returned instead. Object returned as tibble for single 
tables/problems or a named list for multiple tables/problems.
}
\description{
Access model output table data from an xpdb object.
}
\examples{
# By table name
sdtab <- get_data(xpdb_ex_pk, 'sdtab001')
sdtab

# By problem
tables <- get_data(xpdb_ex_pk, .problem = 1)
tables

# Tip to list available tables in the xpdb
print(xpdb_ex_pk)

}
\seealso{
\code{\link{list_data}}, \code{\link{xpose_data}}, \code{\link{read_nm_tables}}
}
