% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_residuals.R
\name{res_vs_idv}
\alias{res_vs_idv}
\alias{absval_res_vs_idv}
\title{Residuals plotted against the independent variable}
\usage{
res_vs_idv(xpdb, mapping = NULL, res = "CWRES", group = "ID",
  type = "pls", title = "@y vs. @x | @run", subtitle = "Ofv: @ofv",
  caption = "@dir", log = NULL, guide = TRUE, facets, .problem, quiet,
  ...)

absval_res_vs_idv(xpdb, mapping = NULL, res = "CWRES", group = "ID",
  type = "pls", title = "@y vs. @x  | @run", subtitle = "Ofv: @ofv",
  caption = "@dir", log = NULL, guide = FALSE, facets, .problem, quiet,
  ...)
}
\arguments{
\item{xpdb}{An xpose database object.}

\item{mapping}{List of aesthetics mappings to be used for the xpose plot 
(e.g. \code{point_color}).}

\item{res}{Type of residual to be used. Default is "CWRES".}

\item{group}{Grouping variable to be used for lines.}

\item{type}{String setting the type of plot to be used. Can be points 'p',
line 'l', smooth 's' and text 't' or any combination of the four.}

\item{title}{Plot title. Use \code{NULL} to remove.}

\item{subtitle}{Plot subtitle. Use \code{NULL} to remove.}

\item{caption}{Page caption. Use \code{NULL} to remove.}

\item{log}{String assigning logarithmic scale to axes, can be either '', 
'x', y' or 'xy'.}

\item{guide}{Enable guide display (e.g. unity line).}

\item{facets}{Either a character string to use \code{\link[ggforce]{facet_wrap_paginate}}
or a formula to use \code{\link[ggforce]{facet_grid_paginate}}.}

\item{.problem}{The $problem number to be used. By default returns 
the last estimation problem.}

\item{quiet}{Logical, if \code{FALSE} messages are printed to the console.}

\item{...}{Any additional aesthetics to be passed on \code{xplot_scatter}.}
}
\description{
Model residuals plotted against the independent variable (IDV).

The residuals can be one of:
\itemize{
  \item RES: model residuals
  \item WRES: weighted model residuals
  \item CWRES: conditional weighted model residuals
  \item EWRES/ECWRES: Monte Carlo based model residuals
  \item NPDE: Normalized prediction distribution error 
}
}
\section{Layers mapping}{

Plots can be customized by mapping arguments to specific layers. The naming convention is 
layer_option where layer is one of the names defined in the list below and option is 
any option supported by this layer e.g. point_color = 'blue', smooth_method = 'lm', etc.
\itemize{
  \item point: options to \code{geom_point}
  \item line: options to \code{geom_line}
  \item guide: options to \code{geom_abline}
  \item smooth: options to \code{geom_smooth}
  \item text: options to \code{geom_text}
  \item xscale: options to \code{scale_x_continuous} or \code{scale_x_log10}
  \item yscale: options to \code{scale_y_continuous} or \code{scale_y_log10}
}
}

\section{Template titles}{

Template titles can be used to create highly informative diagnostics plots. 
They can be applied to any plot title, subtitle and caption. Template titles 
are defined via a single string containing key variables staring with a `@` (e.g. `@ofv`)
which will be replaced by their actual value when rendering the plot.
For example `'@run, @nobs observations in @nind subjects'` would become 
`'run001, 1022 observations in 74 subjects'`. The available key variables 
are listed under \code{\link{template_titles}}.
}

\examples{
# Standard residual
res_vs_idv(xpdb_ex_pk, res = c('IWRES', 'CWRES'))

# Absolute value of the residuals
absval_res_vs_idv(xpdb_ex_pk, res = 'CWRES')

}
\seealso{
\code{\link{xplot_scatter}}
}
