% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strip_side_effect_messages.R
\name{strip_msg}
\alias{strip_msg}
\title{Strips messages of non-alphanumeric characters and rethrows them}
\usage{
strip_msg(x, remove_spaces = FALSE, remove_numbers = FALSE)
}
\arguments{
\item{x}{Code that potentially throws warnings, messages, or an error.}

\item{remove_spaces}{Whether to remove all whitespaces. (Logical)}

\item{remove_numbers}{Whether to remove all numbers. (Logical)}
}
\value{
Returns \code{NULL} invisibly.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

Catches side effects (error, warnings, messages), strips the message strings of
non-alphanumeric characters with \code{\link[xpectr:strip]{strip()}} and regenerates them.

When numbers in error messages vary slightly between systems
(and this variation isn't important to catch), we can strip the numbers as well.

Use case: Sometimes testthat tests have differences in punctuation and newlines on different
systems. By stripping both the error message and the expected message
(with \code{\link[xpectr:strip]{strip()}}), we can avoid such failed tests.
}
\examples{
# Attach packages
library(xpectr)
library(testthat)

\donttest{
strip_msg(stop("this 'dot' .\n is removed! 123"))
strip_msg(warning("this 'dot' .\n is removed! 123"))
strip_msg(message("this 'dot' .\n is removed! 123"))
strip_msg(message("this 'dot' .\n is removed! 123"), remove_numbers = TRUE)
error_fn <- function(){stop("this 'dot' .\n is removed! 123")}
strip_msg(error_fn())

# With testthat tests
expect_error(strip_msg(error_fn()),
             strip("this 'dot' .\n is removed! 123"))
expect_error(strip_msg(error_fn(), remove_numbers = TRUE),
             strip("this 'dot' .\n is removed! 123", remove_numbers = TRUE))
}
}
\seealso{
Other strippers: 
\code{\link{strip}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{strippers}
