\name{firstden}
\alias{firstden}

\title{Distance to a crossover}

\description{
  Calculates the density of the distance from an arbitrary point to the
  next crossover, for the gamma model.
}

\usage{
firstden(nu, L=103, x, n=400, max.conv=25)
}
\arguments{
 \item{nu}{The interference parameter in the gamma model.}
\item{L}{Maximal distance (in cM) at which to calculate the
  density. Ignored if \code{x} is specified.}
\item{x}{If specified, points at which to calculate the density.}
\item{n}{Number of points at which to calculate the density.  The points
  will be evenly distributed between 0 and \code{L}. Ignored if \code{x}
  is specified.}
\item{max.conv}{Maximum limit for summation in the convolutions to get
  inter-crossover distance distribution from the inter-chiasma distance
  distributions.  This should be greater than the maximum number of
  chiasmata on the 4-strand bundle.}
}

\value{
  A data frame with two columns: \code{x} is the distance (between 0
  and \code{L}, in cM) at which the density was calculated and \code{f} is the
  density. 
}

\details{
  Let \eqn{f(x;\nu)}{f(x;nu)} denote the density of a gamma random
  variable with parameters shape=\eqn{\nu}{nu} and rate=\eqn{2\nu}{2
    nu}, and let \eqn{f_k(x;\nu)}{f_k(x;\nu)} denote the density of a gamma random
  variable with parameters shape=\eqn{k \nu}{k nu} and rate=\eqn{2\nu}{2
    nu}.  

  The distribution of the distance from one crossover to the next is
  \eqn{f^*(x;\nu) = \sum_{k=1}^{\infty} f_k(x;\nu)/2^k}{f*(x;nu) = sum_(k=1 to infty)
    f_k(x;\nu)/2^k}.

  The distribution of the distance from an arbitrary point to
  the first crossover is \eqn{g^*(x;\nu) = 1 - F^*(x;\nu)}{g*(x;nu) = 1
    - F*(x;nu)} where \eqn{F^*}{F*} is the cdf of \eqn{f^*}{f*}.
}

\references{
  Broman,  K. W. and Weber, J. L. (2000) Characterization of human
  crossover interference. \emph{Am. J. Hum. Genet.} \bold{66},
  1911--1926. 

  Broman, K. W., Rowe, L. B., Churchill, G. A. and Paigen, K. (2002)
  Crossover interference in the mouse. \emph{Genetics} \bold{160}, 1123--1131.

  McPeek, M. S. and Speed, T. P. (1995) Modeling interference in genetic
  recombination.  \emph{Genetics} \bold{139}, 1031--1044.
}

\author{Karl W Broman, \email{kbroman@biostat.wisc.edu}}

\examples{
f1 <- firstden(1, L=200, n=201)
plot(f1, type="l", lwd=2, las=1,
     ylim=c(0,0.012), yaxs="i", xaxs="i", xlim=c(0,200))

f2 <- firstden(2.6, L=200, n=201)
lines(f2, col="blue", lwd=2)

f3 <- firstden(4.3, L=200, n=201)
lines(f3, col="red", lwd=2)

f4 <- firstden(7.6, L=200, n=201)
lines(f4, col="green", lwd=2)
}

\seealso{ \code{\link{location.given.one}},
    \code{\link{first.given.two}},
      \code{\link{distance.given.two}},
\code{\link{joint.given.two}},	\code{\link{ioden}}, 
	\code{\link{xoprob}},
      \code{\link{gammacoi}}  } 


\keyword{distribution}
