% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loss_functions.R
\name{loss_functions}
\alias{loss_functions}
\alias{loss_mse}
\alias{loss_auc}
\title{loss functions}
\usage{
loss_mse(Y, LOO, na.rm = FALSE)

loss_auc(Y, LOO)
}
\arguments{
\item{Y}{the label matrix with observed responses}

\item{LOO}{the leave-one-out crossvalidation (or predictions if you
must). This one can be calculated by the function \code{loo}.}

\item{na.rm}{a logical value}
}
\description{
These functions can be used as loss functions in \code{\link{tune}}.
Currently, two functions are provided: a function calculating the
classic mean squared error (\code{loss_mse}) and a function
calculating 1 - AUC (\code{loss_auc}).
}
\details{
The AUC is calculated by sorting the \code{Y} matrix based on
the order of the values in the \code{LOO} matrix. The false and true
positive rates are calculated solely based on that ordering, which
allows for values in \code{LOO} outside the range [0,1]. It's
a naive implementation which is good enough for tuning, but
shouldn't be used as a correct value for 1 - auc in case the
values in \code{LOO} are outside the range [0,1].
}
\section{Note}{

The function \code{loss_auc} should only be used for a \code{Y}
matrix that contains solely the values 0 and 1.
}

\examples{

x <- c(1,0,0,1,0,0,1,0,1)
y <- c(0.8,-0.1,0.2,0.2,0.4,0.01,1.12,0.9,0.9)
loss_mse(x,y)
loss_auc(x,y)

}
\seealso{
\code{\link{tune}} for application of the loss function
}
