% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{labels.tskrr}
\alias{labels.tskrr}
\alias{labels,tskrr-method}
\alias{dimnames,tskrr-method}
\alias{dimnames.tskrr}
\alias{rownames,tskrr-method}
\alias{colnames,tskrr-method}
\title{Extract labels from a tskrr object}
\usage{
\method{labels}{tskrr}(
  object,
  prefix = if (is_homogeneous(object)) "row" else c("row", "col"),
  ...
)

\S4method{labels}{tskrr}(
  object,
  prefix = if (is_homogeneous(object)) "row" else c("row", "col"),
  ...
)

\S4method{dimnames}{tskrr}(x)

\S4method{rownames}{tskrr}(x, do.NULL = TRUE, prefix = "row")

\S4method{colnames}{tskrr}(x, do.NULL = TRUE, prefix = "col")
}
\arguments{
\item{object}{a \code{\link{tskrr}} object}

\item{prefix}{a prefix used for construction of the labels in case
none are available. For \code{label}, a character vector of length 1 for
homogeneous networks or of length 2 for heterogeneous networks.
In case two values are given, the first is used for the rows and the second
for the columns. Otherwise the only value is used for both. In the case of
\code{rownames} and \code{colnames}, a single value.
See also \code{\link[=colnames]{row+colnames}}}

\item{...}{arguments passed to/from other methods.}

\item{x}{a \code{\link{tskrr}} object}

\item{do.NULL}{logical. If \code{FALSE} and labels are \code{NULL},
labels are created. If \code{TRUE}, the function returns \code{NULL} in
the absence of labels.}
}
\value{
for \code{labels} and \code{dimnames}: a list with two elements \code{k} and
\code{g}
}
\description{
These functions allow you to extract the labels from a
\code{\link{tskrr}} object. The function \code{labels} and the
function \code{dimnames} are aliases and do the exact same
thing. The functions \code{rownames} and \code{colnames} work like
you would expect. Note that contrary to the latter two, \code{labels}
will never return \code{NULL}. If no labels are found, it will construct
labels using the prefixes defined in the argument \code{prefix}.
}
\section{Warning}{

If the original data didn't contain row- or column names for the
label matrix, \code{rownames} and \code{colnames} will return
\code{NULL}. Other functions will extract the automatically generated
labels, so don't count on \code{rownames} and \code{colnames} if you
want to predict output from other functions!
}

