% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectGene.R
\name{SelectSTournament}
\alias{SelectSTournament}
\title{Stochastic tournament selection.}
\usage{
SelectSTournament(fit, lF, size = 1)
}
\arguments{
\item{fit}{Fitness vector.}

\item{lF}{Local configuration.}

\item{size}{Number of selected genes. Default: 1.}
}
\value{
The index vector of the selected genes.
}
\description{
\code{SelectSTournament} implements selection
             through a stochastic tournament between 
              \code{lF$TournamentSize()} 
             randomly selected genes. A gene wins a tournament 
             with a probability proportional to its fitness.
             The default of \code{lF$TournamentSize()} is \code{2}. 
             A tournament
             with 2 participants has the least selection pressure.
             
             \code{lF$TournamentSize} must be less than the population size.
}
\examples{
fit<-sample(10, 15, replace=TRUE)
SelectSTournament(fit, NewlFselectGenes()) 
SelectSTournament(fit, NewlFselectGenes(), length(fit)) 
}
\seealso{
Other Selection Functions: 
\code{\link{SelectDuel}()},
\code{\link{SelectLRSelective}()},
\code{\link{SelectLinearRankTSR}()},
\code{\link{SelectPropFitDiffM}()},
\code{\link{SelectPropFitDiffOnln}()},
\code{\link{SelectPropFitDiff}()},
\code{\link{SelectPropFitM}()},
\code{\link{SelectPropFitOnln}()},
\code{\link{SelectPropFit}()},
\code{\link{SelectSUS}()},
\code{\link{SelectTournament}()},
\code{\link{SelectUniformP}()},
\code{\link{SelectUniform}()}
}
\concept{Selection Functions}
