% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectGene.R
\name{SelectPropFit}
\alias{SelectPropFit}
\title{Selection proportional to fitness \eqn{O(n^2)}.}
\usage{
SelectPropFit(fit, lF, size = 1)
}
\arguments{
\item{fit}{Fitness vector.}

\item{lF}{Local configuration.}

\item{size}{Number of selected genes. Default: 1.}
}
\value{
The index vector of the selected genes.
}
\description{
\code{SelectPropFit} implements selection
             proportional to fitness. Negative fitness
             vectors are shifted to \eqn{R^+}.
             The default of the function \code{lf$Offset} is \code{1}. 
             Holland's schema theorem uses this selection function.
             See John Holland (1975) for further information.
}
\section{Warning}{

             There is a potential slow for-loop in the code.
}

\examples{
fit<-sample(10, 15, replace=TRUE)
SelectPropFit(fit, NewlFselectGenes()) 
SelectPropFit(fit, NewlFselectGenes(), length(fit)) 
}
\references{
Holland, John (1975): 
             \emph{Adaptation in Natural and Artificial Systems},  
             The University of Michigan Press, Ann Arbor.
             (ISBN:0-472-08460-7)
}
\seealso{
Other Selection Functions: 
\code{\link{SelectDuel}()},
\code{\link{SelectLRSelective}()},
\code{\link{SelectLinearRankTSR}()},
\code{\link{SelectPropFitDiffM}()},
\code{\link{SelectPropFitDiffOnln}()},
\code{\link{SelectPropFitDiff}()},
\code{\link{SelectPropFitM}()},
\code{\link{SelectPropFitOnln}()},
\code{\link{SelectSTournament}()},
\code{\link{SelectSUS}()},
\code{\link{SelectTournament}()},
\code{\link{SelectUniformP}()},
\code{\link{SelectUniform}()}
}
\concept{Selection Functions}
