% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaPopulation.R
\name{xegaSummaryPopulation}
\alias{xegaSummaryPopulation}
\title{Provide elementary summary statistics of the fitness of the population.}
\usage{
xegaSummaryPopulation(pop, fit, lF, iter = 0)
}
\arguments{
\item{pop}{Population of genes.}

\item{fit}{Vector of fitness values of \code{pop}.}

\item{lF}{Local function configuration.}

\item{iter}{The generation. Default: \code{0}.}
}
\value{
The number \code{0}.
}
\description{
\code{SummaryPopulation()} reports
             on the fitness and the value of the best solution
             in the population.
             
             The value of \code{lF$Verbose()} controls the
             information displayed:
             \enumerate{ 
             \item \code{== 0}: Nothing is displayed.

             \item \code{== 1}: 1 point per generation.

             \item \code{> 1}: Max(fit), number of solutions, indices.

             \item \code{> 2}: and population fitness statistics.
      
             \item \code{> 3}: and 1 solution.
             }
}
\examples{
pop10<-xegaInitPopulation(10, lFxegaGaGene)
epop10<-xegaEvalPopulation(pop10, lFxegaGaGene)
rc<-xegaSummaryPopulation(epop10$pop, epop10$fit, lFxegaGaGene, iter=12)

}
\seealso{
Other Population Layer: 
\code{\link{xegaBestGeneInPopulation}()},
\code{\link{xegaBestInPopulation}()},
\code{\link{xegaEvalPopulation}()},
\code{\link{xegaInitPopulation}()},
\code{\link{xegaLogEvalsPopulation}()},
\code{\link{xegaNextPopulation}()},
\code{\link{xegaObservePopulation}()},
\code{\link{xegaRepEvalPopulation}()}
}
\concept{Population Layer}
