% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{cols_type}
\alias{cols_type}
\title{columns by type}
\usage{
cols_type(dt, type)
}
\arguments{
\item{dt}{a data frame.}

\item{type}{a string of data types, available values including character, numeric, double, integer, logical, factor, datetime.}
}
\description{
The columns name of a data frame by given data types.
}
\examples{
dt = data.frame(a = sample(0:9, 6), b = sample(letters, 6),
                c = Sys.Date()-1:6, d = Sys.time() - 1:6)
dt
# numeric columns
cols_type(dt, 'numeric')
# or
cols_type(dt, 'n')

# numeric and character columns
cols_type(dt, c('character', 'numeric'))
# or
cols_type(dt, c('c', 'n'))

# date time columns
cols_type(dt, 'datetime')

}
