% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freezeframe.R
\name{freezeframe}
\alias{freezeframe}
\alias{use_freezeframe}
\alias{html_dependency_freezeframe}
\title{FreezeFrame}
\usage{
use_freezeframe(
  selector = "img[src$=\\"gif\\"]",
  trigger = c("click", "hover", "none"),
  overlay = FALSE,
  responsive = TRUE,
  warnings = TRUE
)

html_dependency_freezeframe()
}
\arguments{
\item{selector}{The selector used to search for \code{.gifs} to freeze.}

\item{trigger}{The trigger event to start animation for non-touch devices.
One of \code{"click"} (default), \code{"hover"} or \code{"none"}.}

\item{overlay}{Whether or not to display a play icon on top of the paused
image, default: \code{FALSE}.}

\item{responsive}{Whether or not to make the image responsive (100\% width),
default: \code{TRUE}.}

\item{warnings}{Whether or not to issue warnings in the browser console if
an image doesn't appear to be a gif.}
}
\value{
An \code{htmltools::tagList()} with the FreezeFrame dependencies, or an
\code{\link[htmltools:htmlDependency]{htmltools::htmlDependency()}}.
}
\description{
FreezeFrame starts any gifs on a slide when you turn to that slide. This
helps This helps alleviate the awkward pause that can happen when you turn to
a slide with a gif that has already started and you have to wait until it
loops back around. You can also directly click on the gif to stop or start
it.
}
\section{Functions}{
\itemize{
\item \code{use_freezeframe}: Adds FreezeFrame to your xaringan slides.

\item \code{html_dependency_freezeframe}: Returns an \code{\link[htmltools:htmlDependency]{htmltools::htmlDependency()}} with the
FreezeFrame dependencies for use in xaringan and R Markdown documents.
Most users will want to use \code{use_freezeframe()} instead.
}}

\section{Usage}{
 To add FreezeFrame to your \code{xaringan} presentation,
add the following code chunk to your slides' R Markdown file.

\if{html}{\out{<div class="sourceCode markdown">}}\preformatted{```\{r xaringanExtra-freezeframe, echo=FALSE\}
xaringanExtra::use_freezeframe()
```
}\if{html}{\out{</div>}}
}

\examples{
use_freezeframe()

}
\references{
\url{http://ctrl-freaks.github.io/freezeframe.js/},
\url{https://github.com/ctrl-freaks/freezeframe.js/}
}
