% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{xQTLvisual_geneExpTissues}
\alias{xQTLvisual_geneExpTissues}
\title{Violin plot of distribution of the gene expression profiles among multiple tissues.}
\usage{
xQTLvisual_geneExpTissues(
  gene = "",
  geneType = "auto",
  tissues = "All",
  datasetId = "gtex_v8",
  log10y = FALSE,
  toTissueSite = FALSE
)
}
\arguments{
\item{gene}{(character) gene symbol or gencode id (versioned or unversioned are both supported).}

\item{geneType}{(character) options: "auto","geneSymbol" or "gencodeId". Default: "auto".}

\item{tissues}{A character string or a vector. "All" (default) means that all tissues is included.}

\item{datasetId}{(character) options: "gtex_v8" (default), "gtex_v7".}

\item{log10y}{Display values of expression in log scale. Default: FALSE.}

\item{toTissueSite}{TRUE or FALSE, display all subtissues or tissue Site. Default: TURE.}
}
\value{
A list containing expression profile and a ggplot object.
}
\description{
Violin plot of distribution of the gene expression profiles among multiple tissues.
}
\examples{
\donttest{
# Display gene expression in specified tissues.
geneExpTissues <- xQTLvisual_geneExpTissues("TP53", tissues=c("Lung", "Brain","Ovary"))
}
}
