% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.R
\name{xQTLanalyze_qtlSpecificity}
\alias{xQTLanalyze_qtlSpecificity}
\title{eQTL-specific analysis}
\usage{
xQTLanalyze_qtlSpecificity(
  gene = "",
  geneType = "auto",
  variantName = "",
  variantType = "auto",
  binNum = 4,
  study = "",
  population = "EUR"
)
}
\arguments{
\item{gene}{(character) gene symbol or gencode id (versioned or unversioned are both supported).}

\item{geneType}{(character) options: "auto","geneSymbol" or "gencodeId". Default: "auto".}

\item{variantName}{(character) name of variant, dbsnp ID and variant id is supported, eg. "rs138420351" and "chr17_7796745_C_T_b38".}

\item{variantType}{(character) options: "auto", "snpId" or "variantId". Default: "auto".}

\item{binNum}{A integer value. Number of bins to split values of R2 of LD into homogeneous bins.}

\item{study}{Studies can be listed using "ebi_study_tissues". If the study is null, use all studies (Default).}

\item{population}{(string) One of the 5 popuations from 1000 Genomes: 'AFR', 'AMR', 'EAS', 'EUR', and 'SAS'.}
}
\value{
A list containing four data.table objects, including: "snpLD" for LD details of the specified SNP; "assoAllLd" for eQTL details of LD-associated SNPs;  "lm_R2_logP" for liner regression results; "cor_R2_logP" for correlation outputs;
}
\description{
eQTL-specific analysis
}
\examples{
\donttest{
speDT <- xQTLanalyze_qtlSpecificity(gene="MMP7", variantName="rs11568818", study="")
xQTLvisual_qtlSpecificity(speDT, outPlot = "heatmap")
xQTLvisual_qtlSpecificity(speDT, outPlot = "regression")
}
}
