% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{dbsnpQueryRange}
\alias{dbsnpQueryRange}
\title{retrieve snps from dbSNP using coordinate.}
\usage{
dbsnpQueryRange(
  chrom = "",
  startPos = -1,
  endPos = -1,
  genomeBuild = "GRCh38/hg38",
  track = "snp151Common"
)
}
\arguments{
\item{chrom}{(character) name of chromesome, including chr1-chr22, chrX, chrY.}

\item{startPos}{A positive integer.}

\item{endPos}{A positive integer.}

\item{genomeBuild}{"GRCh38/hg38" or "GRCh38/hg19". Default: "GRCh38/hg38".}

\item{track}{"snp151Common", "snp150Common" or "snp147Common". Default: "snp151Common".}
}
\value{
A data.table object.
}
\description{
retrieve snps from dbSNP using coordinate.
}
\examples{
snpInfo <- dbsnpQueryRange(chrom="chr1", startPos=1,
                           endPos=50000, genomeBuild="GRCh38/hg38",
                           track="snp151Common" )
}
