% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{xQTLdownload_eqtlSig}
\alias{xQTLdownload_eqtlSig}
\title{Download significant eQTL associations of a specified tissue or across all tissues.}
\usage{
xQTLdownload_eqtlSig(
  variantName = "",
  genes = "",
  variantType = "auto",
  geneType = "auto",
  tissueSiteDetail = "",
  datasetId = "gtex_v8"
)
}
\arguments{
\item{variantName}{(character) name of variant, dbsnp ID and variant id is supported, eg. "rs138420351" and "chr17_7796745_C_T_b38".}

\item{genes}{(character string or a character vector) gene symbols or gencode ids (versioned or unversioned are both supported).}

\item{variantType}{(character) options: "auto", "snpId" or "variantId". Default: "auto".}

\item{geneType}{(character) options: "auto","geneSymbol" or "gencodeId". Default: "auto".}

\item{tissueSiteDetail}{(character) details of tissues in GTEx can be listed using \code{tissueSiteDetailGTExv8} or \code{tissueSiteDetailGTExv7}}

\item{datasetId}{(character) options: "gtex_v8" (default), "gtex_v7".}
}
\value{
A data.table object.
}
\description{
Download significant eQTL associations of a specified tissue or across all tissues.
}
\examples{
\donttest{
# Download eQTL info for a variant:
xQTLdownload_eqtlSig("rs201327123")
xQTLdownload_eqtlSig("chr1_14677_G_A_b38")
xQTLdownload_eqtlSig("11_66328719_T_C_b37", datasetId="gtex_v7")
xQTLdownload_eqtlSig("11_66328719_T_C_b37", datasetId="gtex_v7",
                    tissueSiteDetail="Skin - Sun Exposed (Lower leg)")

# Download eQTL association according to all tissues with genome location:
varInfo <-  xQTLquery_varPos(chrom="chr1", pos=c(1102708),"gtex_v8")
xQTLdownload_eqtlSig(variantName=varInfo$snpId)

# Download eQTL info for gene:
xQTLdownload_eqtlSig(genes="ATAD3B")
xQTLdownload_eqtlSig(genes=c("TP53", "SLC35E2B"), tissueSiteDetail= "Brain - Cerebellum")
xQTLdownload_eqtlSig(genes="ENSG00000141510.16", datasetId="gtex_v8")
xQTLdownload_eqtlSig(genes="ENSG00000141510.11", datasetId="gtex_v7",
                     tissueSiteDetail="Thyroid" )

# Download eQTL info for a variant-gene pair:
xQTLdownload_eqtlSig(variantName="rs1641513", genes="TP53", datasetId="gtex_v8")
xQTLdownload_eqtlSig(variantName="rs1641513", genes="TP53", datasetId="gtex_v7")
xQTLdownload_eqtlSig(variantName="chr1_1667948_A_G_b38",
                     genes="SLC35E2B", tissueSiteDetail="Kidney - Cortex")
}
}
