% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_lines_x3p.R
\name{x3p_add_grid}
\alias{x3p_add_grid}
\title{Add a grid of helper lines to the mask of an x3p object}
\usage{
x3p_add_grid(x3p, spaces, size = c(1, 3, 5), color = c("grey50",
  "black", "darkred"))
}
\arguments{
\item{x3p}{x3p object}

\item{spaces}{space between grid lines, doubled for x}

\item{size}{width (in pixels) of the lines}

\item{color}{(vector of) character values to describe color of lines}
}
\value{
x3p object with added vertical lines in the mask
}
\description{
Add a grid of lines to overlay the surface of an x3p object.
Lines are added to a mask. In case no mask exists, one is created.
}
\examples{
\dontrun{
logo <- read_x3p(system.file("csafe-logo.x3p", package = "x3ptools"))
# ten vertical lines across:
logoplus <- x3p_add_grid(logo,
  spaces = 50e-6, size = c(1, 3, 5),
  color = c("grey50", "black", "darkred")
)
image_x3p(logoplus, size = c(741, 419), zoom = 0.5)
}
}
