% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapvars.R
\name{map_upper}
\alias{map_upper}
\title{Map up-cased symbol names to referenced values if those values are string scalars (else throw).}
\usage{
map_upper(...)
}
\arguments{
\item{...}{symbol names mapping to string scalars}
}
\value{
map from original symbol names to new names (names found in the current environment)
}
\description{
Map up-cased symbol names to referenced values if those values are string scalars (else throw).
}
\examples{

x <- 'a'
print(map_upper(x))
d <- data.frame(a = "a_val")
let(map_upper(x), paste(d$X, x))

}
\seealso{
\code{\link{let}}
}
