% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atblock.R
\name{seval}
\alias{seval}
\title{Execute expr with general substitutions specified in alias.}
\usage{
seval(alias, expr, ..., eval = TRUE, debugPrint = FALSE)
}
\arguments{
\item{alias}{mapping from free names in expr to target names to use.}

\item{expr}{block to prepare for execution.}

\item{...}{force later arguments to be bound by name.}

\item{eval}{logical if TRUE execute the re-mapped expression (else return it).}

\item{debugPrint}{logical if TRUE print debugging information when in stringsubs mode.}
}
\value{
result of expr executed in calling environment (or expression if eval==FALSE)
}
\description{
Note: this method uses string substitution and is willing to substitute in arbitrary content,
please prefer using \code{\link{let}} where applicable.
}
\examples{

seval(c(COLS= "c('Sepal.Width', 'Petal.Length')"),
      head(iris[, COLS, drop=FALSE]) )

}
\seealso{
\code{\link{let}}, \code{\link{ateval}}, \code{\link{beval}}
}
