% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotROC.R
\name{plotROC}
\alias{plotROC}
\title{Plot ROC curves}
\usage{
plotROC(dat, ..., useCol = 2:3, methNames = NULL, col = NULL,
  pch = 1, bg = NULL, tit = NULL, point05 = 0.05, pointSi = 0.85,
  nByMeth = NULL, colPanel = c(grDevices::grey(0.4), 2:5),
  speciesOrder = NULL, txtLoc = c(0.4, 0.3, 0.04), legCex = 0.72,
  silent = FALSE, callFrom = NULL)
}
\arguments{
\item{dat}{(matrix) from testing (eg  \code{\link{summarizeForROC}} )}

\item{...}{additional input (must be of same type of format as 'dat')}

\item{useCol}{(integer or character) colors to be used}

\item{methNames}{(character) names of methods (data-sets) to be displayed}

\item{col}{(character) custom color}

\item{pch}{(integer) type of symbol to be used (see \code{\link[graphics]{par}})}

\item{bg}{(character) background color in plot (see \code{\link[graphics]{par}})}

\item{tit}{(character) custom title}

\item{point05}{(numeric) specific point to highlight in plot (typically at alpha=0.05)}

\item{pointSi}{(numeric) size of points (as expansion factor \code{cex})}

\item{nByMeth}{(integer) value of n to display}

\item{colPanel}{(character) custom colors}

\item{speciesOrder}{(integer) custom order of species in legend}

\item{txtLoc}{(numeric) location for text}

\item{legCex}{(numeric) cex expansion factor for legend}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allows easier tracking of messages produced}
}
\value{
plot only
}
\description{
\code{plotROC} plots ROC curves based on results from \code{\link{summarizeForROC}}. 
Does not return any data, plot only.
}
\examples{
set.seed(2019); test1 <- list(annot=cbind(spec=c(rep("b",35),letters[sample.int(n=3,
  size=150,replace=TRUE)])),BH=matrix(c(runif(35,0,0.01),runif(150)),ncol=1))
tail(roc1 <- summarizeForROC(test1,spec=c("a","b","c"),plotROC=FALSE))
plotROC(roc1)
}
\seealso{
\code{\link{summarizeForROC}}, \code{\link[wrMisc]{moderTest2grp}}
}
