% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minDiff.R
\name{minDiff}
\alias{minDiff}
\title{Minimum distance/difference between values}
\usage{
minDiff(x, digSig = 3, ppm = TRUE, initOrder = TRUE, callFrom = NULL)
}
\arguments{
\item{x}{(numeric) vector to search minimum difference}

\item{digSig}{number of significant digits, used for ratio or ppm column}

\item{ppm}{(logical) display distance as ppm (1e6*diff/refValue, ie normalized difference eg as used in mass spectrometry), otherwise the ratio is given as : value(from 'x') / closestValue (from 'x')}

\item{initOrder}{(logical) return matrix so that 'x' matches exactely 2nd col of output}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
matrix
}
\description{
\code{minDiff} aims to find the min distance (ie closest point) to any other x (numeric value), ie intra 'x' and
 returns matrix with 'index','value','dif','ppm','ncur','nbest','best'.
At equal distance to lower & upper neighbour point, the upper (following) point is chosen (as single best).
In case of multiple ex-aequo distance returns 1st of multiple, may be different at various repeats.
}
\examples{
set.seed(2017); aa <- 100*c(0.1+round(runif(20),2),0.53,0.53)
minDiff(aa); minDiff(aa,initO=TRUE,ppm=FALSE); .minDif(unique(aa))
}
\seealso{
\code{\link[stats]{dist}}
}
