% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readTabulatedBatch.R
\name{readTabulatedBatch}
\alias{readTabulatedBatch}
\title{Batch Reading Of Tabulated Text-Files}
\usage{
readTabulatedBatch(
  query,
  path = NULL,
  dec = ".",
  header = "auto",
  strip.white = FALSE,
  blank.lines.skip = TRUE,
  fill = FALSE,
  filtCol = 2,
  filterAsInf = TRUE,
  filtVal = 5000,
  silent = FALSE,
  callFrom = NULL,
  debug = FALSE
)
}
\arguments{
\item{query}{(character) vector of file-names to be read, if \code{"."} all files will be read (no matter what their extension might be)}

\item{path}{(character) path for reading files, if \code{NULL} or \code{NA} the current directory will be used}

\item{dec}{(character, length=1) decimals to use, will be passed to \code{\link[data.table]{fread}} or \code{\link[utils]{read.delim}}}

\item{header}{(character, length=1) path for reading files, if \code{NULL} or \code{NA} the current directory will be used, will be passed to \code{\link[data.table]{fread}} or \code{\link[utils]{read.delim}}}

\item{strip.white}{(logical, length=1) Strips leading and trailing whitespaces of unquoted fields, will be passed to \code{\link[data.table]{fread}} or \code{\link[utils]{read.delim}}}

\item{blank.lines.skip}{(logical, length=1)  If \code{TRUE} blank lines in the input are ignored. will be passed to \code{\link[data.table]{fread}} or \code{\link[utils]{read.delim}}}

\item{fill}{(logical, length=1) If \code{TRUE} then in case the rows have unequal length, blank fields are implicitly filled, will be passed to \code{\link[data.table]{fread}} or \code{\link[utils]{read.delim}}}

\item{filtCol}{(integer, length=1) which columns should be used for filtering, if \code{NULL} or \code{NA} all data will be returned}

\item{filterAsInf}{(logical, length=1) filter as inferior or equal (\code{TRUE}) or superior or equal threshold \code{filtVal}}

\item{filtVal}{(numeric, length=1) which numeric threshold should be used for filtering, if \code{NULL} or \code{NA} all data will be returned}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of messages produced}

\item{debug}{(logical) display additional messages for debugging}
}
\value{
This function returns a list of data.frames
}
\description{
This function allows batch reading of multiple tabulated text files n batch. 
The files can be designed specifically, or, alternatively all files from a given directory can be read.
If package \href{https://CRAN.R-project.org/package=data.table}{data.table} is available, faster reading of files will be performed using the function \code{\link[data.table]{fread}}.
}
\details{
If you want to provide a flexible pattern of ffile-names, this has to be done before calling this usntion, eg using \code{grep} to provide an explicit collection of flles.
However, it is possible to read different files from different locations/directories, the length of \code{path} must match the length of \code{query}
}
\examples{
path1 <- system.file("extdata", package="wrMisc")
fiNa <-  c("a1.txt","a2.txt")
allTxt <- readTabulatedBatch(fiNa, path1)
str(allTxt)

}
\seealso{
\code{\link[data.table]{fread}}, \code{\link[utils]{read.delim}}, for reading batch of csv files : \code{\link{readCsvBatch}}
}
