% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowGrpSums.R
\name{rowGrpSums}
\alias{rowGrpSums}
\title{rowSums with destinction of groups (of columns, eg groups of replicates)}
\usage{
rowGrpSums(x, grp, na.rm = TRUE)
}
\arguments{
\item{x}{matrix or data.frame}

\item{grp}{(character or factor) defining which columns should be grouped (considered as replicates)}

\item{na.rm}{(logical) a logical value indicating whether \code{NA}-values should be stripped before the computation proceeds.}
}
\value{
This function a matrix with row/group sum values
}
\description{
This function calculates row-sums for matrix with multiple groups of data, ie similar to \code{rowSums} but one summed value for each line and group of data.
Groups are specified as columns of 'x' in 'grp' (so length of grp should match number of columns of 'x', NAs are allowed).
}
\examples{
set.seed(2016); dat1 <- matrix(c(runif(200) +rep(1:10,20)), ncol=10)
head(rowGrpMeans(dat1, gr=gl(4, 3, labels=LETTERS[1:4])[2:11]))
}
\seealso{
\code{\link{rowGrpMeans}}, \code{\link{rowGrpSds}}, \code{\link{rowSds}}, \code{\link[base]{colSums}}
}
