% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterList.R
\name{filterList}
\alias{filterList}
\title{Filter for unique elements}
\usage{
filterList(lst, filt, minLineRatio = 0.5, silent = FALSE, callFrom = NULL)
}
\arguments{
\item{lst}{(list) main input, each vector, matrix or data.frame in this list will be filtered if its length or number of lines fits to \code{filt}}

\item{filt}{(logical) vector of \code{FALSE/TRUE} to use for filtering. If this a matrix is given, the value of \code{minLineRatio} will be applied as threshod of min content of \code{TRUE} for each line of \code{filt}}

\item{minLineRatio}{(numeric) in case \code{filt} is a matrix of \code{FALSE/TRUE}, this value will be used as threshold of min content of \code{TRUE} for each line of \code{filt}}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
filtered list
}
\description{
This function aims to apply a given filter-citerium, a matrix or vector of \code{FALSE/TRUE} which is typically combined with a second layer   
which filters for a min content of filer-passing values per line for the first/main criterium.
Then all lines concerned will be removed. This will be done for all list-elements (of appropriate size) of the input-list  
(while maintaining the list-structure in the output) not matching the filtering criteria.
}
\examples{
set.seed(2020); dat1 <- round(runif(80),2)
list1 <- list(m1=matrix(dat1[1:40],ncol=8), m2=matrix(dat1[41:80],ncol=8), other=letters[1:8])
rownames(list1$m1) <- rownames(list1$m2) <- paste0("line",1:5)
filterList(list1, list1$m1[,1] >0.4) 
filterList(list1, list1$m1 >0.4) 
}
\seealso{
\code{\link{correctToUnique}}, \code{\link[base]{unique}}, \code{\link[base]{duplicated}}, \code{\link{extrColsDeX}}
}
